/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.socks.socks5server.io;

import java.io.IOException;
import java.net.Socket;
import org.simplejavamail.mailer.internal.socks.socks5server.io.StreamPipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketPipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketPipe.class);
    private static final String INPUT_PIPE_NAME = "INPUT_PIPE";
    private static final String OUTPUT_PIPE_NAME = "OUTPUT_PIPE";
    private final StreamPipe pipe1;
    private final StreamPipe pipe2;
    private final Socket socket1;
    private final Socket socket2;
    private String name;
    private boolean running = false;
    private final PipeListener listener = new PipeListener();

    public SocketPipe(Socket socket1, Socket socket2) throws IOException {
        this.socket1 = socket1;
        this.socket2 = socket2;
        this.pipe1 = new StreamPipe(socket1.getInputStream(), socket2.getOutputStream(), OUTPUT_PIPE_NAME);
        this.pipe2 = new StreamPipe(socket2.getInputStream(), socket1.getOutputStream(), INPUT_PIPE_NAME);
        this.pipe1.addPipeListener(this.listener);
        this.pipe2.addPipeListener(this.listener);
    }

    public void start() {
        this.running = this.pipe1.start() && this.pipe2.start();
    }

    public void stop() {
        if (this.running) {
            this.pipe1.stop();
            this.pipe2.stop();
            if (this.pipe1.isStopped() && this.pipe2.isStopped()) {
                this.running = false;
            }
        }
    }

    private void close() {
        this.pipe2.removePipeListener(this.listener);
        this.pipe1.removePipeListener(this.listener);
        this.stop();
        try {
            if (this.socket1 != null && !this.socket1.isClosed()) {
                this.socket1.close();
            }
            if (this.socket2 != null && !this.socket2.isClosed()) {
                this.socket2.close();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setName(String name) {
        this.name = name;
    }

    public class PipeListener {
        public String getName() {
            return SocketPipe.this.name;
        }

        public void onStop(StreamPipe streamPipe) {
            LOGGER.trace("Pipe[{}] stopped", (Object)streamPipe.getName());
            SocketPipe.this.close();
        }
    }
}

